/*
Copyright 2008-2009 Elöd Egyed-Zsigmond, Cyril Laitang
Copyright 2009-2011 Samuel Gesche

This file is part of IPRI News Analyzer.

IPRI News Analyzer is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

IPRI News Analyzer is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with IPRI News Analyzer.  If not, see <http://www.gnu.org/licenses/>.
*/

package proc.analyse;

import data.base.Config;
import data.structures.analyse.CorpusAnalyse;
import data.structures.analyse.SacArticles;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

import java.util.HashMap;
import java.util.Map;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

import javax.swing.JLabel;

/**
 *
 * @author Utilisateur
 */
public class ClassifieurSVM {

    public static void reclasse(CorpusAnalyse corpus, JLabel jauge) throws IOException {
        // Liste des classes (le pot commun est une classe)
        jauge.setText("SVM : Listage des sujets.");
        Vector<SacArticles> classes = new Vector<SacArticles>();
        for(int i=0; i<corpus.getSujets().length; i++){
            if(!(corpus.getSujets()[i].getTitre().equals(CorpusAnalyse.NOM_SUJET_DIVERS))){
                classes.addElement(corpus.getSujets()[i]);
            }
        }

        // Liste des articles à trier
        jauge.setText("SVM : Listage des articles à trier.");
        SacArticles aTrier = corpus.getSujet(CorpusAnalyse.NOM_SUJET_DIVERS);
        if(aTrier == null){
            return;
        }

        // Création de la liste de lemmes
        jauge.setText("SVM : Création de la liste de lemmes.");
        Set<String> lemmes0 = new HashSet<String>();
        for(int i=0; i<classes.size(); i++){
            jauge.setText("SVM : Création de la liste de lemmes (sujet "+(i+1)+"/"+classes.size()+").");
            for(int j=0; j<classes.elementAt(i).getArticles().length; j++){
                for(int k=0; k<classes.elementAt(i).getArticles()[j].getLemmesTitre().length; k++){
                    lemmes0.add(classes.elementAt(i).getArticles()[j].getLemmesTitre()[k]);
                }
                for(int k=0; k<classes.elementAt(i).getArticles()[j].getLemmesDescription().length; k++){
                    lemmes0.add(classes.elementAt(i).getArticles()[j].getLemmesDescription()[k]);
                }
            }
        }
        String[] lemmes = new String[lemmes0.size()];
        lemmes0.toArray(lemmes);
        Map<String, Integer> inverse = new HashMap<String, Integer>();
        for(int i=0; i<lemmes.length; i++){
            inverse.put(lemmes[i], new Integer(i));
        }

        // Création des vecteurs des classes
        jauge.setText("SVM : Création des vecteurs des sujets.");
        Vector<double[]> vecteursClasses = new Vector<double[]>();
        Vector<Integer> classesDocuments = new Vector<Integer>();
        for(int i=0; i<classes.size(); i++){
            jauge.setText("SVM : Création des vecteurs des sujets (sujet "+(i+1)+"/"+classes.size()+").");
            for(int j=0; j<classes.elementAt(i).getArticles().length; j++){
                double[] d = new double[lemmes.length];
                int noClasse = i+1;
                for(int k=0; k<classes.elementAt(i).getArticles()[j].getLemmesTitre().length; k++){
                    String l = classes.elementAt(i).getArticles()[j].getLemmesTitre()[k];
                    d[inverse.get(l).intValue()] += 1.0;
                }
                for(int k=0; k<classes.elementAt(i).getArticles()[j].getLemmesDescription().length; k++){
                    String l = classes.elementAt(i).getArticles()[j].getLemmesDescription()[k];
                    d[inverse.get(l).intValue()] += 1.0;
                }
                vecteursClasses.addElement(d);
                classesDocuments.addElement(new Integer(noClasse));
            }
        }

        // Création des vecteurs des documents à trier
        jauge.setText("SVM : Création des vecteurs des articles à trier.");
        Vector<double[]> vecteursATrier = new Vector<double[]>();
        for (int j = 0; j < aTrier.getArticles().length; j++) {
            jauge.setText("SVM : Création des vecteurs des articles à trier (article "+(j+1)+"/"+aTrier.getArticles().length+").");
            double[] d = new double[lemmes.length];
            for (int k = 0; k < aTrier.getArticles()[j].getLemmesTitre().length; k++) {
                String l = aTrier.getArticles()[j].getLemmesTitre()[k];
                if(inverse.get(l) != null){
                    d[inverse.get(l).intValue()] += 1.0;
                }
            }
            for (int k = 0; k < aTrier.getArticles()[j].getLemmesDescription().length; k++) {
                String l = aTrier.getArticles()[j].getLemmesDescription()[k];
                if(inverse.get(l) != null){
                    d[inverse.get(l).intValue()] += 1.0;
                }
            }
            vecteursATrier.addElement(d);
        }

        // Application du tf.idf
        jauge.setText("SVM : Pondération des vecteurs.");



        // Ecriture des fichiers
        jauge.setText("SVM : Enregistrement.");
        File repSVM = new File(Config.getClassificationDirectory());
        new File(repSVM.getPath()+"/test/").mkdirs();
        File fichierClasses = new File(repSVM.getPath()+"/test/classes.dat");
        fichierClasses.createNewFile();
        FileWriter wClasses = new FileWriter(fichierClasses);
        for(int i=0; i<vecteursClasses.size(); i++){
            jauge.setText("SVM : Enregistrement (sujets : article "+(i+1)+"/"+vecteursClasses.size()+").");
            wClasses.write("" + classesDocuments.elementAt(i).intValue());
            for (int j = 0; j < vecteursClasses.elementAt(i).length; j++) {
                if(vecteursClasses.elementAt(i)[j]>0){
                    wClasses.write(" " + (j+1) + ":" + vecteursClasses.elementAt(i)[j]);
                }
            }
            wClasses.write(" #"+(i+1)+"\r\n");
            wClasses.flush();
        }
        wClasses.close();
        File fichierATrier = new File(repSVM.getPath()+"/test/aTrier.dat");
        fichierATrier.createNewFile();
        FileWriter wATrier = new FileWriter(fichierATrier);
        for(int i=0; i<vecteursATrier.size(); i++){
            jauge.setText("SVM : Enregistrement (à trier : article "+(i+1)+"/"+vecteursATrier.size()+").");
            wATrier.write("0");
            for(int j=0; j<vecteursATrier.elementAt(i).length; j++){
                if(vecteursATrier.elementAt(i)[j]>0){
                    wATrier.write(" "+(j+1)+":"+vecteursATrier.elementAt(i)[j]);
                }
            }
            wATrier.write(" #"+(i+1)+"\r\n");
            wATrier.flush();
        }
        wATrier.close();

        // Lancement de la classification
        jauge.setText("SVM : Apprentissage.");
        String inst = "\""+repSVM.getAbsolutePath()+"\\svm_multiclass_learn.exe\" -c 5000 \""+
                repSVM.getAbsolutePath()+"\\test\\classes.dat\" \""+
                repSVM.getAbsolutePath()+"\\test\\modele.txt\"";/* >\""+
                repSVM.getAbsolutePath()+"\\test\\logmodele.txt\" 2>\""+
                repSVM.getAbsolutePath()+"\\test\\errmodele.txt\"";*/
        System.out.println(inst);
        Process classification = Runtime.getRuntime().exec(inst);
        try {
            classification.waitFor();
        } catch (InterruptedException ex) {
            
        }

        jauge.setText("SVM : Classification.");
        inst = "\""+repSVM.getAbsolutePath()+"\\svm_multiclass_classify.exe\" \""+
                repSVM.getAbsolutePath()+"\\test\\aTrier.dat\" \""+
                repSVM.getAbsolutePath()+"\\test\\modele.txt\" \""+
                repSVM.getAbsolutePath()+"\\test\\logs.txt\"";/* >\""+
                repSVM.getAbsolutePath()+"\\test\\logclassification.txt\" 2>\""+
                repSVM.getAbsolutePath()+"\\test\\errclassification.txt\"";*/
        System.out.println(inst);
        classification = Runtime.getRuntime().exec(inst);   
        try {
            classification.waitFor();
        } catch (InterruptedException ex) {
            
        }
        
        jauge.setText("C'est tout pour l'instant.");
    }
}
